
window.suppressSubmit = false;

    function convert_result_key_string(key) {
        const cleanKey = key.replace(/^(r_|p_)/, '');
        return window.result_labels[cleanKey];
    }
    function update_results(resultsData) {
        $(".sidebar .results-group:first .table .table-row:not(.header)").remove();
        let allRows = '';

        Object.entries(resultsData.sidebar).forEach(([key, value]) => {
            let table_cells = '';
            let total_cells = 0;

            const table_cell = `
                <div class="table-cell">
                    <span class="cell_title">[result_key]</span>
                    <span class="h2" data-result="[result_key]">[result]</span>
                </div>`;

            Object.entries(value).forEach(([result_key, result]) => {
                total_cells++;
                const last_key = convert_result_key_string(result_key);
                table_cells += table_cell
                    .replace(/\[result_key\]/g, last_key)
                    .replace('[result]', result);
            });

            if (total_cells === 1) {
                table_cells += table_cell.replace(/\[result_key\]/g, '').replace('[result]', '-');
            }

            allRows += `<div class="table-row">${table_cells}</div>`;
        });
        $(".sidebar .results-group:first .table").append(allRows);
        Object.entries(resultsData.multi_pipe).forEach(([key, value]) => {
            var result_key = parseInt(key) + 1;
            $(`[data-result="multi[result_${result_key}]"]`).val(value.result);
            $(`[data-result="multi[product_${result_key}]"]`).val(value.product);
        });
    }


    function submit_calculation(){
        // return false;
        var formData = new FormData(); 
        $(".main_calc .card:visible").find("input, select, textarea").each(function () {
            var input = $(this);
            if (input.attr("name")) { 
                if ((input.is(":checkbox") || input.is(":radio")) && !input.is(":checked")) {
                    return; 
                }
                formData.append(input.attr("name"), input.val()); 
            }
        });
        fetch('./results.json', { // Change to correct calculation url
            method: 'GET'
            // method: 'POST',
            // body: formData
        })
        .then(response => {
            if (!response.ok) throw new Error('Network response was not ok');
            return response.json(); 
        })
        .then(data => {
            update_results(data);
        })
        .catch(error => {
            console.error('Form submission failed:', error);
        });


    };
    function unregister_change() {
        $(".main_calc .card:visible").find("input, select, textarea").off("change.submit");
    }
    function bindChangeHandler() {
        $(".main_calc .card:visible").find("input, select, textarea")
            .off("change.submit")
            .on("change.submit", function (e) {
                if (!window.suppressSubmit) {
                    submit_calculation();
                }
            });
    }
    function load_default_values(){
        var calc_type = $('input[name="calc_type"]:checked').val();
        var sub_calc_type = $('input[name="geometry"]:checked').val();
        
        window.suppressSubmit = true;
            fetch('./defaults.json')
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json(); 
            })
            .then(data => {
                var default_data = data[calc_type][sub_calc_type];
                var total_items = Object.keys(default_data).length;
                var run_counter = 0;
                unregister_change();
                    Object.keys(default_data).forEach(function(key) {
                        run_counter++;
                        var default_key = key;
                        var default_value = default_data[key];
                        var container = $("[data-default='"+default_key+"']");
                        if(run_counter == total_items){
                            window.suppressSubmit = false; 
                            bindChangeHandler();
                        }
                        if(container.attr("type") == "radio"){
                            container.each(function(el){
                                if($(this).attr("data-val") == default_value){
                                    $(this).trigger("click");
                                }
                            });
                            
                        } else if (container.is('select')){
                            container.each(function(el){
                                if(!$(this).is('select')){
                                    var selected_value = $(this).find("li.selected").attr("data-value");
                                    if(selected_value != default_value){
                                        $(this).find("li[data-value='"+default_value+"']").trigger("click");
                                    }
                                }
                            });
                        } else if(default_key == "rockwool_product"){
                            $(".product_card_container .product_info span").text(default_value);
                        }  else {
                            if(typeof default_value === 'object' && default_value !== null && !Array.isArray(default_value)){
                                
                                $("[data-default='"+default_key+"']").attr("min", default_value.min).attr("max", default_value.max);
                                default_value = default_value.value;
                            }
                            $("[data-default='"+default_key+"']").val(default_value);
                            if(container.is('input[type="range"]')){
                                container.css('--value', `${(container.val() - container.attr('min')) / (container.attr('max') - container.attr('min')) * 100}%`);
                            }
                        }
                        if(run_counter == total_items){
                            submit_calculation();
                        }

                        
                    });
                
            })
            .catch(error => {
                console.error('There has been a problem with your fetch operation:', error);
            });
        
    }
// Handle default values end

// Handle export
    function handle_export_checkboxes(){
        $(".export_calc_selector").html("");
        var total_calculations = $(".calc_tabs li").length;
        if(total_calculations > 1){
            var checkbox = '<div class="input-group"><label class="radio-option body_1 med"><input type="checkbox" name="export_calc" value="0">Select all</label></div>';
            $(".export_calc_selector").append(checkbox);
            $(".calc_tabs li").each(function (index, element) {
                var calc_name = $(element).text();
                var calc_ref = $(element).attr("data-ref");
                var checkbox = '<div class="input-group"><label class="radio-option body_1 med"><input type="checkbox" name="export_calc" value="'+calc_ref+'">'+calc_name+'</label></div>';
                $(".export_calc_selector").append(checkbox);
            });
        }
    }
    function export_pdf(){
        $(".export_overlay .popup_content").toggle();
        $(".export_overlay .loader_pdf").toggle();
        setTimeout(function(){
            close_overlay('export_pdf')
        }, 5000);
    };
    function load_products() {
        $(".product_list").html(""); 
        var calc = parseInt($("[name='geometry']:checked").val());
        var product_cat = 1;
        if(calc == 3 || calc == 4){
            product_cat = 2;
        }
        fetch('./products.json')
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json(); 
            })
            .then(data => {
                var html = '';
                data.forEach(product => {
                    if(product.product_category != product_cat && product.product_category != 3){
                        return;
                    }
                    html += `
                        <div class="product_card ${product.is_recommended === "1" ? 'recommend' : ''} p-1 cursor_p w-100" data-product="${product.product_id}">
                            <div class="product_img">
                                <i class="rw-icon rw-icon-select cursor_p"></i>
                                <img src="${product.product_image}" alt="${product.product_name}">
                            </div>
                            <div class="product_info">
                                <span class="body_1 bold">${product.product_name}</span>
                                <hr>
                                <a href="${product.product_url}" class="btn_f flex" target="_blank">View details 
                                    <img src="assets/svg/arrow-right-grey.svg" alt="arrow">
                                </a>
                            </div>
                        </div>
                    `;
                });
                document.querySelector('.product_list').innerHTML = html;
            })
            .catch(error => {
                console.error('There has been a problem with your fetch operation:', error);
            });
    }
    
// Handle export end
// Handle overlays
    function open_overlay(overlay){
        if(overlay == "product_selector"){
            load_products();
            $("html").addClass("overlay_open");
        }
        if(overlay == "add_calculation"){
            $("#new_calc_name").val("");
            $("html").addClass("add_calc_open");
        }
        if(overlay == "rename_calculation"){
            $("#rename_calc").val($(".calc_tabs li.active").text());
            $("html").addClass("rename_calc_open");
        }
        if(overlay == "delete_calc"){
            $("html").addClass("delete_calc_open");
        }
        if(overlay == "export_pdf"){
            handle_export_checkboxes();
            $(".export_overlay .popup_content").show();
            $(".export_overlay .loader_pdf").hide();
            $("html").addClass("export_overlay_open");
        }
    }
    function close_overlay(overlay){
        if(overlay == "product_selector"){
            $("html").removeClass("overlay_open");
        }
        if(overlay == "add_calculation"){
            $("html").removeClass("add_calc_open");
        }
        if(overlay == "rename_calculation"){
            $("html").removeClass("rename_calc_open");
        }
        if(overlay == "delete_calc"){
            $("html").removeClass("delete_calc_open");
        }
        if(overlay == "export_pdf"){
            $("html").removeClass("export_overlay_open");
        }
    }
    function handle_calc_selections(){
        $(".main_calc input[name='calc_type']").closest(".radio-option").removeClass("disabled");
        $(".main_calc input[name='geometry']").closest(".img_radio").removeClass("disabled");
        
        var disable_calc = $(".main_calc input[name='calc_type']:checked").attr("data-disable");

        if (disable_calc) {
            $(".main_calc input[name='geometry']").filter(function() {
                return disable_calc.split(",").includes(this.value);
            }).closest(".img_radio").addClass("disabled");
        }

        var disable_calc = $(".main_calc input[name='geometry']:checked").attr("data-disable");

        if (disable_calc) {
            $(".main_calc input[name='calc_type']").filter(function() {
                return disable_calc.split(",").includes(this.value);
            }).closest(".radio-option").addClass("disabled");
        }
            
    }
    function show_extra_fields(){
        var current_main = $('[name="calc_type"]:checked').val();
        $('[data-extra^="main"]').addClass("hide");
        $('[data-extra="main_' + current_main + '"]').removeClass("hide");
    }
    function reset_classes(type = "all"){
        if(type == "all"){
            var type_installation = $(document).find("[name='type_installation']").siblings(".select_box");
            type_installation.find("li[data-value=' ']").trigger("click");
            
            var insulation_class = $(document).find("[name='insulation_class']").siblings(".select_box");
            insulation_class.find("li[data-value=' ']").trigger("click");
        }
    };
    function change_calc(e, type = "main"){
        if(type == "sub"){
            if($.isNumeric(e)){ var calc_type = e;} 
            else { var calc_type = $(e).val();}
            $('.main_calc .card[data-sub_calc]').hide();
            $('.main_calc .card[data-sub_calc*="'+calc_type+'"]').show();



            var type_installation = $(document).find("[name='type_installation']").siblings(".select_box");
            type_installation.find("li").not("[data-value=' ']").hide();
            type_installation.find("li[data-calc_type*='"+calc_type+"']").show();

            var insulation_class = $(document).find("[name='insulation_class']").siblings(".select_box");
            insulation_class.find("li").not("[data-value=' ']").hide();
            insulation_class.find("li[data-calc_type*='"+calc_type+"']").show();

            reset_classes("all");


            // $('.sidebar .results .table-row[data-sub_calc]').hide();
            // $('.sidebar .results .table-row[data-sub_calc*="'+calc_type+'"]').show();
        } else {
            if($.isNumeric(e)){ var calc_type = e;} 
            else { var calc_type = $(e).val();}
            $('.main_calc .card:not([data-calc="0"]):not([data-sub_calc])').hide();
            $('.main_calc .card[data-calc*="'+calc_type+'"]:not([data-calc="0"]):not([data-sub_calc])').show();
            // $('.sidebar .results .table-row:not([data-calc="0"]):not([data-sub_calc])').hide();
            // $('.sidebar .results .table-row[data-calc*="'+calc_type+'"]:not([data-calc="0"])').show();
            // $('.sidebar .results .results-group .table-row').removeClass("last-visible");
            // $('.sidebar .results .results-group').first().find('.table .table-row:visible').last().addClass('last-visible');
            // $('.sidebar .results .results-group').last().find('.table .table-row:visible').last().addClass('last-visible');
        }
        handle_calc_selections();
        load_default_values();
        show_extra_fields();

    }
    change_calc(1);


    function handle_close_selectbox(){
        
        $("#calc_options").removeClass("active");

        
        $(".select_body").hide();
        $(".select_submenu").hide();
        $(".select_header").removeClass("active");
    }

    function open_dropdown(e){
        var dropdown = $(e).attr("data-dropdown");
        var input_container = $(e).closest(".input-group");
        var select_box = input_container.find("[data-dropdown_o='"+dropdown+"']").next();

        if(select_box.find(".select_body").is(":visible")){
            handle_close_selectbox();
        } else {
            select_box.find(".select_header").trigger("click");
        }
        
    }

// Handle overlay End
    function scrollToTop() {
        window.scrollTo({
            top: 0,
            behavior: "smooth"
        });
    }

    $(document).ready(function () {
        
        // Select box start
        var selectbox_template = $(".select_box.template").prop('outerHTML');
        $(".select_box.template").remove();
        window.renderCustomSelects = function() {
            $(document).find("select").each(function (index, element) {
                var select = $(element);
                select.hide();
                var options = $(select).find("option");
                var optgroups = select.find("optgroup");
                var placeholder = select.find("option[placeholder]").text();
                var selectbox = $(selectbox_template);
                var select_after = select.attr("data-after");
                var dataset_select = select.data();
                
                selectbox.removeClass("template");
                selectbox.attr("data-placeholder", placeholder).find(".select_header span").text(placeholder);
                selectbox.find(".select_body ul").empty();
                selectbox.attr("data-after", select_after);
                
                for (var key in dataset_select) {
                    if (dataset_select.hasOwnProperty(key)) {
                        if(key != "dropdown_o" || key != "after"){
                            selectbox.attr("data-"+key, dataset_select[key]);
                        }
                    }
                }

                if(optgroups.length){
                    var submenu = $("<div>").addClass("select_submenu");
                    var sub_counter = 0;
                    optgroups.each(function (index, optgroup) {
                        var optgroup = $(optgroup);
                        var text = optgroup.attr("label");
                        var li = $("<li>").addClass("has_sub").attr("data-sub", sub_counter);
                        var options = optgroup.find("option");
                        
                        var span = $("<span>").addClass("body_1 med").text(text);
                        li.append(span);

                        
                        options.each(function (index, option) {
                            var option = $(option);
                            var dataset = option.data();
                            
                            var value = option.val();
                            if(value == "") {
                                return;
                            }
                            var text = option.text();
                            var selected = option.prop("selected");
                            var li_sub = $("<li>").attr("data-value", value).attr("data-sub_no", sub_counter);
                            for (var key in dataset) {
                                if (dataset.hasOwnProperty(key)) {
                                    li_sub.attr("data-"+key, dataset[key]);
                                }
                            }
            
                            var span = $("<span>").addClass("body_1 med").text(text);
                            li_sub.append(span);
                            submenu.append(li_sub);
                        });
                        sub_counter++;

                        selectbox.find(".select_body ul").append(li);
                    });
                    submenu.hide();
                selectbox.append(submenu);
                } else {
                    options.each(function (index, option) {
                        var option = $(option);
                        var dataset = option.data();
                        
                        var value = option.val();
                        if(value == "") {
                            return;
                        }
                        var text = option.text();
                        var selected = option.prop("selected");
                        var li = $("<li>").attr("data-value", value);
                        for (var key in dataset) {
                            if (dataset.hasOwnProperty(key)) {
                                li.attr("data-"+key, dataset[key]);
                            }
                        }
        
                        var span = $("<span>").addClass("body_1 med").text(text);
                        li.append(span);
                        if(selected){
                            li.addClass("selected");
                            selectbox.find(".select_header span").text(text);
                        }
                        selectbox.find(".select_body ul").append(li);
                    });

                }
                select.after(selectbox);
            });
        }

        // Handle selectbox options
        $(document).on("click", ".select_header", function (e) {
            e.preventDefault();
            var select_box = $(this);
            if($(this).next().is(":visible")){
                handle_close_selectbox();

            } else {
                setTimeout(function(){
                    select_box.addClass("active");
                }, 100);
                handle_close_selectbox();
                $(this).next().show();
            }
        });

        // Handle selectbox selection
        $(document).on("click", ".select_body li, .select_submenu li", function (e) {
            e.preventDefault();
            if($(this).hasClass("has_sub")){
                return false;
            }
            if($(this).hasClass("selected")){
                return false;
            }
            if($(this).closest("#calc_options").length){
                handle_close_selectbox();
                return false;
            }
            $(this).siblings().removeClass("selected");
            var select_group = $(this).closest(".input-group");
            
            var selected_value = $(this).attr("data-value");
            var selected_text = $(this).find("span").text();
            var select_box = select_group.find("select");
            handle_close_selectbox();
            if($(this).hasClass("selected")){
                $(this).removeClass("selected");
                select_box.val("");
                select_group.find(".select_header span").text(select_box.find("option[placeholder]").text());
            } else {
                $(this).addClass("selected");
                select_box.val(selected_value);
                select_group.find(".select_header span").text(selected_text);
            }

            if(select_box.attr("data-set_unit")){
                var unit = $(this).attr("data-unit");
                var data_ref = select_box.attr("data-set_unit");
                select_group.find("[data-get_unit="+data_ref+"]").attr("data-unit", unit);
            }
            if(select_box.attr("data-set_val")){
                var value = $(this).attr("data-value");
                var data_ref = select_box.attr("data-set_val");
                select_group.find("[data-get_val="+data_ref+"]").find("input").val(value);
            }
            select_box.trigger("change");
        });
        $(document).on("mouseenter", ".select_body li.has_sub", function (e) {
            var sub_container = $(this).closest(".select_box").find(".select_submenu");
            var sub_no = $(this).attr("data-sub");
            sub_container.find("li").hide();
            sub_container.find("li[data-sub_no='"+sub_no+"']").show();
            sub_container.show();
        });

        
        $(document).keydown(function (e) { 
            if(e.key == "Escape"){
                handle_close_selectbox();
                if($("html").hasClass("overlay_open")){
                    close_overlay('product_selector');
                }
            }
        });
        $(document).click(function (e) {
            // Handle select close
            if(!$(e.target).closest(".select_body").length && 
                !$(e.target).closest(".select_header").length && 
                !$(e.target).attr("data-dropdown") &&
                !$(e.target).closest("#calc_options").length
            ){
                handle_close_selectbox();
            }
        });
        // Select box end

        // Range box start
        
        window.initializeRangeAndNumberInputs = function() {
            const range_sliders = document.querySelectorAll('input[type="range"]');
            const range_inputs = document.querySelectorAll('.range-input input');
        
            function updateRangeInput() {
                var radio_group = $(this).parents(".input-group");
                radio_group.find(".range-input input").val(this.value);
                this.style.setProperty('--value', `${(this.value - this.min) / (this.max - this.min) * 100}%`);
            }
        
            range_sliders.forEach(function(range_slider) {
                range_slider.addEventListener('input', function() {
                    updateRangeInput.call(this);
                });
        
                updateRangeInput.call(range_slider);
            });
        
            range_inputs.forEach(function(range_input) {
                range_input.addEventListener('change', function() {
                    const range_slider = this.closest('.input-group').querySelector('input[type="range"]');
                    range_slider.value = this.value; 
                    updateRangeInput.call(range_slider); 
                });
            });
        
            document.querySelectorAll('input[type="number"]').forEach(function (input) {
                input.addEventListener('change', function () {
        
                    const min = parseInt(this.min);
                    const max = parseInt(this.max);
                    let value = parseInt(this.value);
        
                    if (isNaN(value)) {
                        return;
                    }
        
                    if (value < min) {
                        this.value = min;
                    } 
                    else if (value > max) {
                        this.value = max;
                    }
                });
            });
        };
        window.initializeRangeAndNumberInputs();
        // input number end

        function hasScrollbar(element) {
            return element.scrollHeight > element.clientHeight;
        }

        const element = document.querySelector('.overlay_body.c_scroll');

        if (hasScrollbar(element)) {
            element.classList.add('scrollbar-visible');
        } else {
            element.classList.remove('scrollbar-visible');
        }

        window.addEventListener('resize', function() {
        if (hasScrollbar(element)) {
            element.classList.add('scrollbar-visible');
        } else {
            element.classList.remove('scrollbar-visible');
        }
        });

        $(document).on("click", ".overlay_backdrop", function (e) {
            if (!$(e.target).closest(".overlay_content").length) {
                close_overlay("product_selector"); 
            }
        });

        // Arrows on number
        window.reinitializeNumberInputs = function() {
            document.querySelectorAll('input[type="number"].h_arrow').forEach(function(input) {
                var wrapper = input.closest('.num-input') || input.closest('.range-input');;
                
                if (wrapper) {
                    var existingArrows = wrapper.querySelector('.arrow-controls');
                    if (existingArrows) {
                        existingArrows.remove(); 
                    }
        
                    var arrowControls = document.createElement('div');
                    arrowControls.className = 'arrow-controls';
                    var upArrow = document.createElement('span');
                    upArrow.className = 'up-arrow';
                    upArrow.innerHTML = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.87708 10.0731L8.87708 6.07306L12.8771 10.0731" stroke="white" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/></svg>';
        
                    var downArrow = document.createElement('span');
                    downArrow.className = 'down-arrow';
                    downArrow.innerHTML = '<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M4.87708 6.07306L8.87708 10.0731L12.8771 6.07306" stroke="white" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/></svg>';
        
                    arrowControls.appendChild(upArrow);
                    arrowControls.appendChild(downArrow);
        
                    wrapper.appendChild(arrowControls);
        
                    function positionArrows() {
                        var inputWidth = input.offsetWidth; 
                        arrowControls.style.left = (inputWidth - 25) + "px"; 
                    }
        
                    var intersectionObserver = new IntersectionObserver(function(entries) {
                        entries.forEach(function(entry) {
                            if (entry.isIntersecting) {
                                positionArrows(); 
                            }
                        });
                    });
        
                    intersectionObserver.observe(input);
                    var resizeObserver = new ResizeObserver(function() {
                        positionArrows(); 
                    });
        
                    resizeObserver.observe(input);
        
                    upArrow.addEventListener('click', function() {
                        input.stepUp();
                        input.dispatchEvent(new Event('change', { bubbles: true }));
                    });
        
                    downArrow.addEventListener('click', function() {
                        input.stepDown();
                        input.dispatchEvent(new Event('change', { bubbles: true }));
                    });
                }
            });
        };
        
        window.reinitializeNumberInputs();
        

        $("input[name='product_type']").change(function (e) { 
            e.preventDefault();
            var product_type_val = $(this).val();

            if(product_type_val == 2){
                $(".insulation_layers").addClass("active_select");
            } else {

                $(".insulation_layers").removeClass("active_select");
            }
        });


        window.template_calc = $(".calculator").contents().clone(true);
        setTimeout(function(){
            var type_installation = $(document).find("[name='type_installation']").siblings(".select_box");
            type_installation.find("li").not("[data-value=' ']").hide();
            type_installation.find("li[data-calc_type*='1']").show();

            
            var class_cont = $(document).find("[name='insulation_class']").siblings(".select_box");
            class_cont.find("li:not([data-value=' '])").hide();
            class_cont.find("li[data-calc_type*='1']").show();
        }, 200);
    });


// Product handler
    $(document).on("click", ".product_list .product_card", function (e) {
        $(".product_list .product_card").removeClass("selected");
        $(this).addClass("selected");
    });

    function select_product(){
        var selected_product = $(".product_list .product_card.selected");
        var product_card_container = $(".product_card_container");
        product_card_container.find(".product_img img").attr("src", selected_product.find("img").attr("src"));
        product_card_container.find(".product_info span").text(selected_product.find(".product_info span").text());
        product_card_container.find(".product_info a").attr("href", selected_product.find(".product_info a").attr('href'));
        product_card_container.find("[name='product_id']").val(selected_product.attr("data-product"));
        $(".product_card_container .input-group").hide();
        $(".product_card_container .product_card").show();
        close_overlay("product_selector");
        submit_calculation();
    }
    function delete_product(){
        
        $(".product_card_container").find("[name='product_id']").val('');
        $(".product_card_container .input-group").show();
        $(".product_card_container .product_card").hide();
        submit_calculation();
    }
    function rel_handler(e){
        var rel = $(e).attr("data-rel");
        var container = $(e).parentsUntil(".card").parent();
        if(rel == "operating_time"){
            if($("[data-rel_c='"+rel+"']").hasClass("hide")){
                $(document).find("[name='insulation_class']").siblings(".select_box").find(".select_body li").show();
            } else {
                $(document).find("[name='installation_part']").trigger("change");
            }
        }
        $("[data-rel_c='"+rel+"']").toggleClass("hide");
        $("[data-rel_h='"+rel+"']").toggleClass("hide");

    }
// Product handler end

// Channel handler
    function append_channel(e){
        var channel_container  = $(e).parent().parent();
        var channel_clone = channel_container.find("li").first().clone();
        channel_container.append(channel_clone);
        channel_container.find(".remove_channel").removeClass("hide");
        channel_container.find(".channel_order").show();
        window.reinitializeNumberInputs();
        submit_calculation();
    }
    function remove_channel(e){
        var channel_container  = $(e).parent().parent();
        channel_container.find("li").last().remove();
        if(channel_container.find("li:not(.channel_actions)").length == 1){
            channel_container.find(".remove_channel").addClass("hide");
            channel_container.find(".channel_order").hide();
        }
        submit_calculation();
    }
    function channel_pos(elem, direction) {
        let currentItem = elem.closest('li');
        if (direction === 'next') {
            let nextItem = currentItem.nextElementSibling;
            if (nextItem) {
                currentItem.parentNode.insertBefore(nextItem, currentItem);
            }
        } else if (direction === 'prev') {
            let prevItem = currentItem.previousElementSibling;
            if (prevItem) {
                currentItem.parentNode.insertBefore(currentItem, prevItem);
            }
        }
        submit_calculation();
    }
    
// Channel handler end
// Additional layers
    function append_layer(e){
        var layer_container  = $(e).siblings(".layers");
        var layers = layer_container.find(".layer");
        var total_layers = layers.length;
        
        if (total_layers != 4) {
            var layer_clone = layers.first().clone();
            var new_index = total_layers + 1;
    
            // Update input names in the clone
            layer_clone.find("input, select, textarea").each(function () {
                var name = $(this).attr("name");
                if (name) {
                    var updated_name = name.replace(/\[\d+\]/, '[' + new_index + ']');
                    $(this).attr("name", updated_name);
                }
            });
    
            layer_container.append(layer_clone);
            set_layer_thickness(layer_container);
        }
        bindChangeHandler();
        if((total_layers + 1) == 4){
            $(e).addClass("disabled");
        }
    }
    function remove_layer(e){
        var layer_container  = $(e).closest(".layers");
        var layers = layer_container.find(".layer");
        var total_layers = layers.length;
        
        var input_group  = $(e).closest(".insulation_layers");
        input_group.find(".btn.disabled").removeClass("disabled");
        if(total_layers != 1){
            $(e).parent().remove();
            set_layer_thickness(layer_container);
        }
        
    }
    function set_layer_thickness(e){
        var layers = e.find(".layer");
        var total_layers = layers.length;

        if(total_layers > 2){
            var thickness_container = e.find(".layer-thickness");
            var last_single = thickness_container.find(".single:last-child");
            var height_percent = ((total_layers - 2) / total_layers) * 100;
           
            last_single.css("height", height_percent + "%");
            last_single.removeClass("hide");
        }else {
            var thickness_container = e.find(".layer-thickness");
            var last_single = thickness_container.find(".single:last-child");
            last_single.addClass("hide");
        }

        
    }
    function set_layer_thickness_val(e){
        var select_box = $(e);
        var product_type = select_box.closest(".card").find("input[name='product_type']:checked").val();
        if(product_type == 1){
            var thickness = select_box.siblings(".select_box").find("li[data-value='"+select_box.val()+"']").attr("data-thickness");
            var layer = select_box.closest(".layer");
            layer.find(".thickness").val(thickness);
        }
        submit_calculation();
    }
// Additional layers end

// tabs handler
    window.calculations = [];
    
    function set_tab_border(){
        var active_menu = $(".calc_tabs li.active").width();
        var active_menu_pos = $(".calc_tabs li.active").position().left;
        $(".calc_nav .tab_border").css("width", active_menu);
        $(".calc_nav .tab_border").css("left", active_menu_pos);
        setTimeout(function(){
            $(".results .calc_name").text($(".calc_tabs li.active").text());
        }, 100);
    }
    set_tab_border();

    function save_calc_memory(){
        var ref_key = $(".calc_tabs li.active").attr("data-ref");
        window.calculations[ref_key] = $(".calculator").contents().clone(true);
    }
    function add_calc(calc_name = ""){
        save_calc_memory();
        var load_default = 0;
        var calc_tabs = $(".calc_tabs ul");  
        if(calc_name == ""){
            var load_default = 1;
            var calc_name = $("#new_calc_name").val();
            if(calc_name == ""){ calc_name = "CALCULATION 1"; }
            $("#new_calc_name").val("");
            var calc_model = window.template_calc;
        }
        calc_tabs.find("li").removeClass("active");
        var ref_key = parseInt(calc_tabs.find("li").last().attr("data-ref")) + 1;
        if(isNaN(ref_key)){ ref_key = 1;}
        calc_tabs.append('<li class="active" data-ref="'+ref_key+'">'+calc_name+'</li>');
        set_tab_border();
        $(".calculator").html(calc_model);

        if(load_default){
            $("input[name='geometry']").first().trigger("click");
            $("input[name='calc_type']").first().trigger("click").trigger("change");
            close_overlay('add_calculation');
        }
        window.initializeRangeAndNumberInputs();
        window.reinitializeNumberInputs();

    }
    function change_tab(e){
        var ref = $(e).attr("data-ref");
        save_calc_memory();
        $(".calc_tabs li").removeClass("active");
        $(e).addClass("active");
        $(".calculator").html(window.calculations[ref]);
        set_tab_border();
        window.initializeRangeAndNumberInputs();
        window.reinitializeNumberInputs();

    }
    $(document).on("click", ".calc_tabs li", function (e) {
        change_tab(this);
    });
    
    $("#calc_options").click(function (e) {
        $(this).addClass("active");
        $(this).find(".select_body").toggle();
    });

    function calc_tab_settings(setting){
        var calc_tabs = $(".calc_tabs ul");
        var active_calc = calc_tabs.find("li.active");
        if(setting == 1){
            // duplicate calculation
            calc_name = active_calc.text() + "(1)";
            add_calc(calc_name);
        } else if (setting == 2){
            // rename calculation
            var new_name = $("#rename_calc").val();
            active_calc.text(new_name);
            close_overlay('rename_calculation');
            set_tab_border();
        } else if (setting == 3){
            // delete calculation
            var ref = active_calc.attr("data-ref");
            window.calculations[ref] = '';
            active_calc.remove();
            if(calc_tabs.find("li").length == 0){
                window.calculations = [];
                add_calc();
                set_tab_border();
            }  else {
                calc_tabs.find("li").first().trigger("click");
            }
            set_tab_border();
            close_overlay('delete_calc');
        } else if (setting == 4){
            // reset calculation
            var all_calcs = calc_tabs.find("li").remove();
            window.calculations = [];
            add_calc();
            set_tab_border();


        }

    }
    function applyConditions(conditionString, class_cont) {
        if (!conditionString) return;

        var conds = conditionString.split("|");
        for (var i = 0; i < conds.length; i++) {
            var cond = conds[i];
            var parts = cond.split(":");
            if (parts.length !== 2) continue;

            var check = parts[0]; // e.g. "ambient_temperature<="
            var result = parts[1]; // e.g. "C5V[34,35,36]" or "C5V17"

            // parse input + operator
            var inputName = check.replace(/[<>=]+/g, ""); 
            var operator = check.replace(/[a-zA-Z_]/g, ""); 
            var inputVal = parseFloat($("[name='" + inputName + "']").val());

            // match CxxV...
            var match = result.match(/C(\d+)V(.+)/);
            if (!match) continue;

            var checkNum = parseFloat(match[1]);
            var valuesPart = match[2]; // "17" or "[34,35,36]"

            // normalize into array
            var values;
            if (valuesPart.startsWith("[")) {
                try {
                    values = JSON.parse(valuesPart); // -> [34,35,36]
                } catch (e) {
                    console.error("Invalid values array:", valuesPart);
                    continue;
                }
            } else {
                values = [valuesPart]; // -> ["17"]
            }

            var ok = false;
            switch (operator) {
                case "<":  ok = inputVal <  checkNum; break;
                case ">":  ok = inputVal >  checkNum; break;
                case "<=": ok = inputVal <= checkNum; break;
                case "=>":
                case ">=": ok = inputVal >= checkNum; break;
                case "==": ok = inputVal == checkNum; break;
            }

            if (ok) {
                values.forEach(function(value) {
                    class_cont.find("li[data-value='" + value + "']").show();
                });
                window.condition_applied = conditionString;
                break;
            }
        }
    }

    $(document).on("change", "[name='installation_part']", function (e) {
        if(window.condition_type == "installation_part"){
            window.condition_type = "";
            window.condition_applied = "";
        }
        var selected_val = $(this).val();
        var selected_install = $(document).find("[name='installation_part']").siblings(".select_box").find(".select_body li.selected");
        var condition = selected_install.attr("data-cond");
        var class_cont = $(document).find("[name='insulation_class']").siblings(".select_box");
        if(selected_val == ""){
            class_cont.find(".select_body li").show();
        } else {
            class_cont.find(".select_body li").hide();

            
            if(condition){
                window.condition_type = "installation_part";
                applyConditions(condition, class_cont);
            } else {
                class_cont.find(".select_body li").hide();
                class_cont.find("li").filter(function() {
                    var data = $(this).attr("data-sub_part");
                    if (!data) return false;
                    var subParts = data.split(",");
                    return subParts.includes(selected_val);
                }).show();
            }
            var firstVisible = class_cont.find("li").filter(function () {
                return $(this).css("display") !== "none";
            }).first();
            if (firstVisible.length) {
                firstVisible.trigger("click");
            }

        }
    });
    $(document).on("change", "[name='type_installation']", function (e) {
        if(window.condition_type == "type_installation"){
            window.condition_type = "";
            window.condition_applied = "";
        }
        var selected_val = $(this).val();
        
        var selected_install = $(document).find("[name='type_installation']").siblings(".select_box").find(".select_body li.selected");
        var select_cont = $(document).find("[name='installation_part']").siblings(".select_box");
        var class_cont = $(document).find("[name='insulation_class']").siblings(".select_box");
        var condition = selected_install.attr("data-cond");
        console.log(condition);
        var sub_calc_type = $('input[name="geometry"]:checked').val();
        if(!selected_val){
            select_cont.find(".select_body li").show();
            select_cont.closest(".input-group").addClass("disabled");
            var placeholder = select_cont.find("li[data-value=' '] span").text();
            select_cont.find(".select_header span").text(placeholder);
            // class_cont.find(".select_body li").show();

            class_cont.find("li").filter(function() {
                var data = $(this).attr("data-calc_type");
                if (!data) return false;
                var subParts = data.split(",");
                return subParts.includes(sub_calc_type);
            }).show();
        } else {
            select_cont.find(".select_body li").hide();

            if(condition){
                
                window.condition_type = "type_installation";
                applyConditions(condition, select_cont);
            } else {
                select_cont.find("li[data-sub_part='"+$(this).val()+"']").show();
                var placeholder = select_cont.find("li[data-value=' '] span").text();
                select_cont.find(".select_header span").text(placeholder);
                class_cont.find("li").filter(function() {
                    var data = $(this).attr("data-calc_type");
                    if (!data) return false;
                    var subParts = data.split(",");
                    return subParts.includes(sub_calc_type);
                }).show();
            }
                select_cont.closest(".input-group").removeClass("disabled");

        }
    });
    $(document).on("click", ".multi_row_add", function (e) {
        e.preventDefault();
        var clone_multi = $(".multi_pipe_container .multi_row").first().clone();
        var total_multi = $(".multi_pipe_container .multi_row").length + 1;
        clone_multi.find("input").each(function() {
            $(this).val("1");
            var name = $(this).attr("name");
            if (name) {
                $(this).attr("name", name.replace(/_1/g, "_" + total_multi));
            }
            var dataDefault = $(this).attr("data-default");
            if (dataDefault) {
                $(this).attr("data-default", dataDefault.replace(/_1/g, "_" + total_multi));
            }
            var dataResult = $(this).attr("data-result");
            if (dataResult) {
                $(this).attr("data-result", dataResult.replace(/_1/g, "_" + total_multi));
            }
        });
        clone_multi.find(".multi_order").text(total_multi);
        clone_multi.appendTo(".multi_pipe_container");
        if(total_multi >= 8){
            $(".multi_row_add").addClass("disabled");
        }
    });
    $(document).on("click", ".delete_row", function (e) {
        e.preventDefault();
    
        // Find the row to delete
        var multi_row = $(this).closest(".multi_row");
    
        // Remove the selected row
        multi_row.remove();
    
        // Reorder the remaining rows
        $(".multi_pipe_container .multi_row").each(function(index) {
            $(this).find("input").each(function() {
                var name = $(this).attr("name");
                var dataDefault = $(this).attr("data-default");
                var dataResult = $(this).attr("data-result");
                if (name) {
                    $(this).attr("name", name.replace(/_\d+/g, "_" + (index + 1)));
                }
                if (dataDefault) {
                    $(this).attr("data-default", dataDefault.replace(/_\d+/g, "_" + (index + 1)));
                }
                if (dataResult) {
                    $(this).attr("data-result", dataResult.replace(/_\d+/g, "_" + (index + 1)));
                }
            });
            $(this).find(".multi_order").text(index + 1);
        });
        $(".multi_row_add").removeClass("disabled");
    });

    $(document).on("change", "[data-condition_track]", function (e) {
        var inputName = $(this).data("condition_track");


        if (!window.condition_applied) return;
        if (window.condition_applied.indexOf(inputName) !== -1) {
            if(window.condition_type == "type_installation"){
                var condition_target = "installation_part";
            }
            if(window.condition_type == "installation_part"){
                var condition_target = "insulation_class";
            }
            var class_cont = $(document).find("[name='" + condition_target + "']").siblings(".select_box");
            class_cont.find("li").not("[data-value=' ']").hide();
            applyConditions(window.condition_applied, class_cont);
            var firstVisible = class_cont.find("li").filter(function () {
                return $(this).css("display") !== "none";
            }).first();
            if (firstVisible.length) {
                firstVisible.trigger("click");
            }
        } 
    });
    
// tabs handler end

// Submit calculation
// $(".radio-option input").change(function (e) {
//     submit_calculation();
// });