let translations = {};
let currentLang = "da";
fetch("lang.json")
  .then(response => response.json())
  .then(data => {
    translations = data;
    setLanguage(currentLang); // initialize
  });
function applyLanguageVisibility() {
    $("[data-lang]").each(function () {
        let langs = $(this).attr("data-lang");
        let langList = langs.split(",").map(l => l.trim());
        if (langList.includes(currentLang)) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });


}
function setLanguage(lang) {
  currentLang = lang;

  // Normal elements
  document.querySelectorAll("[data-i18n]").forEach(el => {
    const key = el.getAttribute("data-i18n");
    const translation = translations[lang][key] || key;

    // Remove all existing text nodes
    Array.from(el.childNodes).forEach(node => {
      if (node.nodeType === Node.TEXT_NODE) {
        el.removeChild(node);
      }
    });

    // Insert translation text at the end (after inputs, svgs, etc.)
    el.appendChild(document.createTextNode(" " + translation));
  });


  // Selects
  document.querySelectorAll("[data-i18n-select]").forEach(select => {
    const key = select.getAttribute("data-i18n-select");
    const options = translations[lang].select_options?.[key] || [];
    // Remember current value before rebuild
    const currentValue = select.value;

    // Clear
    select.innerHTML = "";

    options.forEach(optData => {
      const option = document.createElement("option");
        option.setAttribute("value", optData.value);

      // Set attributes (except label/placeholder/selected which we handle separately)
      Object.keys(optData).forEach(attr => {
        if (!["label", "placeholder", "selected"].includes(attr)) {
          option.setAttribute(attr, optData[attr]);
        }
      });

      option.textContent = optData.label;

      // Handle placeholder
      if (optData.placeholder) {
        option.setAttribute("disabled", "");
      }

      // Handle selected
      if (optData.selected || optData.value === currentValue) {
        //  console.log(optData, optData.value, currentValue);
        option.setAttribute("selected", "");
      }

      select.appendChild(option);
    });
  });
  window.result_labels = translations[lang].results_labels || {};
  applyLanguageVisibility();
  window.renderCustomSelects();
  
}



// Language switcher event
// document.getElementById("languageSwitcher").addEventListener("change", (e) => {
//   setLanguage(e.target.value);
// });